/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.connected;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3518;

public class ConnectedModelRegistry {
    private static final BiPredicate<class_2680, class_2680> BLOCK_CONNECTION_PREDICATE = (s1, s2) -> s1.method_26204() == s2.method_26204();
    private static final Map<String, BiPredicate<class_2680, class_2680>> CONNECTION_PREDICATES = new HashMap<String, BiPredicate<class_2680, class_2680>>();
    private static final Map<String, String[]> CONNECTION_TYPES;

    public static void registerPredicate(String name, BiPredicate<class_2680, class_2680> predicate) {
        CONNECTION_PREDICATES.putIfAbsent(name, predicate);
    }

    public static BiPredicate<class_2680, class_2680> deserializePredicate(JsonObject json, String key) {
        String name = class_3518.method_15253((JsonObject)json, (String)key, (String)"block");
        if (!CONNECTION_PREDICATES.containsKey(name)) {
            throw new JsonSyntaxException("Unknown connection predicate " + name);
        }
        return CONNECTION_PREDICATES.get(name);
    }

    public static BiPredicate<class_2680, class_2680> getPredicate(String name) {
        return CONNECTION_PREDICATES.getOrDefault(name, BLOCK_CONNECTION_PREDICATE);
    }

    private static boolean safeGet(class_2680 state, class_2746 prop) {
        return state.method_28498((class_2769)prop) && (Boolean)state.method_11654((class_2769)prop) != false;
    }

    public static void registerType(String name, Function<Predicate<class_2350>, String> mapper) {
        if (!CONNECTION_TYPES.containsKey(name)) {
            String[] suffixes = new String[16];
            for (int i = 0; i < 16; ++i) {
                int index = i;
                suffixes[i] = mapper.apply(dir -> {
                    int flag = 1 << dir.method_10161();
                    return (index & flag) == flag;
                });
            }
            CONNECTION_TYPES.put(name, suffixes);
        }
    }

    public static String[] deserializeType(JsonElement json, String key) {
        String name = class_3518.method_15287((JsonElement)json, (String)key);
        if (!CONNECTION_TYPES.containsKey(name)) {
            throw new JsonSyntaxException("Unknown connection type " + name);
        }
        return CONNECTION_TYPES.get(name);
    }

    static {
        ConnectedModelRegistry.registerPredicate("block", BLOCK_CONNECTION_PREDICATE);
        ConnectedModelRegistry.registerPredicate("pane", (state, neighbor) -> state.method_26204() == neighbor.method_26204() && (ConnectedModelRegistry.safeGet(state, class_2429.field_11332) || ConnectedModelRegistry.safeGet(state, class_2429.field_11335) || ConnectedModelRegistry.safeGet(state, class_2429.field_11331) || ConnectedModelRegistry.safeGet(state, class_2429.field_11328)) == (ConnectedModelRegistry.safeGet(neighbor, class_2429.field_11332) || ConnectedModelRegistry.safeGet(neighbor, class_2429.field_11335) || ConnectedModelRegistry.safeGet(neighbor, class_2429.field_11331) || ConnectedModelRegistry.safeGet(neighbor, class_2429.field_11328)));
        CONNECTION_TYPES = new HashMap<String, String[]>();
        ConnectedModelRegistry.registerType("cornerless_full", predicate -> {
            Object name = "";
            if (predicate.test(class_2350.field_11043)) {
                name = (String)name + "u";
            }
            if (predicate.test(class_2350.field_11035)) {
                name = (String)name + "d";
            }
            if (predicate.test(class_2350.field_11039)) {
                name = (String)name + "l";
            }
            if (predicate.test(class_2350.field_11034)) {
                name = (String)name + "r";
            }
            return name;
        });
        ConnectedModelRegistry.registerType("horizontal", predicate -> {
            boolean right = predicate.test(class_2350.field_11034);
            if (predicate.test(class_2350.field_11039)) {
                return right ? "middle" : "right";
            }
            return right ? "left" : "";
        });
        ConnectedModelRegistry.registerType("vertical", predicate -> {
            boolean bottom = predicate.test(class_2350.field_11035);
            if (predicate.test(class_2350.field_11043)) {
                return bottom ? "middle" : "bottom";
            }
            return bottom ? "top" : "";
        });
        ConnectedModelRegistry.registerType("top", predicate -> predicate.test(class_2350.field_11043) ? "bottom" : "");
    }
}

